<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Log In ‹ Wordpress</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
</head>
<body class="bg-gray-100">
  <div class="w-full max-w-xs mx-auto mt-10"> <!-- Center horizontally and add top margin -->
    <div class="flex justify-center mb-6">
      <img alt="WordPress logo" class="w-24 h-24" src="https://ebwebhosting.com/temp/wordpress-logo-wordpress-icon-transparent-free-png.png"/>
    </div>
    <form class="bg-white shadow-md rounded px-8 pt-6 pb-8 mb-4">
      <div class="mb-4">
        <label class="block text-gray-700 text-sm font-bold mb-2" for="username">
          Username or Email Address
        </label>
        <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="username" placeholder="Username or Email Address" type="text"/>
      </div>
      <div class="mb-4">
        <label class="block text-gray-700 text-sm font-bold mb-2" for="password">
          Password
        </label>
        <div class="relative">
          <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="password" placeholder="Password" type="password"/>
          <span class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5">
            <i class="fas fa-eye"></i>
          </span>
        </div>
      </div>
      <div class="mb-4 flex items-center justify-between">
        <div>
          <input class="mr-2 leading-tight" id="remember_me" type="checkbox"/>
          <label class="text-sm text-gray-700" for="remember_me">Remember Me</label>
        </div>
        <button class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline" type="button">
          Log In
        </button>
      </div>
    </form>
    <div class="text-center">
      <a class="inline-block align-baseline font-bold text-sm text-blue-500 hover:text-blue-800" href="#">
        Lost your password?
      </a>
    </div>
    <div class="text-center mt-4">
      <a class="inline-block align-baseline font-bold text-sm text-gray-500 hover:text-gray-800" href="#">
        ← Go to Wordpress
      </a>
    </div>
  </div>
</body>
</html>